#include <cstdio>
#include <bits/stdc++.h>
using namespace std;

const int N = 3e5 + 5;
const int MAX_NUM = 1e6 + 5;

int n, q;
int a[N];

vector<int> pojavljivanja[MAX_NUM];

double res[MAX_NUM];
int resL[MAX_NUM], resD[MAX_NUM];

int prviNeNulaIndeks = -1;
int sledecaNula[N];

bool flag1e6 = true;

void init()
{
    for (int i = 0; i < MAX_NUM; i++)
    {
        res[i] = -1;
    }

    for (int i = 0; i < n; i++)
    {
        pojavljivanja[a[i]].push_back(i);
    }

    if (pojavljivanja[0].size() == 0)
    {
        prviNeNulaIndeks = 0;
    }
    else
    {
        int i;
        for (i = 0; i < pojavljivanja[0].size(); i++)
        {
            if (pojavljivanja[0][i] != i)
            {
                prviNeNulaIndeks = i;
                break;
            }
        }

        if (i == pojavljivanja[0].size())
        {
            prviNeNulaIndeks = i;
        }
    }

    sledecaNula[n] = n;
    for (int i = n-1; i >= 0; i--)
    {
        if (a[i] == 0)
        {
            sledecaNula[i] = i;
        }
        else
        {
            sledecaNula[i] = sledecaNula[i + 1];
        }
    }
}

// x^a
double stepen(double x, int a)
{
    if (a == 0)
    {
        return 1;
    }
    if (a == 1)
    {
        return x;
    }

    double s = stepen(x, a/2);

    if (a%2 == 0)
    {
        return s * s;
    }
    return s * s * x;
}

void resi(int qi)
{
    if (pojavljivanja[0].size() == n)
    {
        res[qi] = 0;
        resL[qi] = resD[qi] = 0;
        return;
    }

    if (qi == 0 || qi == 1 || pojavljivanja[qi].size() == 0)
    {
        res[qi] = 0;
        resL[qi] = resD[qi] = prviNeNulaIndeks;
        return;
    }

    if (flag1e6)
    {
        for (int i = 0; i < pojavljivanja[qi].size();)
        {
            int jGranica = sledecaNula[pojavljivanja[qi][i]];
            int j;

            for (j = i; j < pojavljivanja[qi].size() && pojavljivanja[qi][j] < jGranica; j++);
            j--;

            if (res[qi] == -1 || (j - i + 1) > res[qi])
            {
                res[qi] = j - i + 1;
                resL[qi] = pojavljivanja[qi][i];
                resD[qi] = pojavljivanja[qi][j];
            }

            i = j+1;
        }

        return;
    }

    for (int i = 0; i < pojavljivanja[qi].size();)
    {
        int jGranica = sledecaNula[pojavljivanja[qi][i]];

        int j;
        for (j = i; j < pojavljivanja[qi].size() && pojavljivanja[qi][j] < jGranica; j++);
        j--;

        int l = pojavljivanja[qi][i], d = pojavljivanja[qi][j];
        double specVred = stepen(qi, j - i + 1) / (d - l + 1);

        if (res[qi] == -1 || specVred > res[qi])
        {
            res[qi] = specVred;
            resL[qi] = l;
            resD[qi] = d;
        }

        int i1;
        for (i1 = i; i1 < j; i1++)
        {
            int l1 = pojavljivanja[qi][i1], l2 = pojavljivanja[qi][i1 + 1];
            int d = pojavljivanja[qi][j];

            double specVred1 = stepen(qi, j - i1 + 1) / (d - l1 + 1);
            double specVred2 = stepen(qi, j - i1) / (d - l2 + 1);

            if (specVred2 > specVred1)
            {
                if (res[qi] == -1 || specVred2 > res[qi])
                {
                    res[qi] = specVred2;
                    resL[qi] = l2;
                    resD[qi] = d;
                }
            }
            else {
                break;
            }
        }

        for (int j1 = j; j1 > i1; j--)
        {
            int l = pojavljivanja[qi][i1];
            int d1 = pojavljivanja[qi][j], d2 = pojavljivanja[qi][j-1];

            double specVred1 = stepen(qi, j1 - i1 + 1) / (d1 - l + 1);
            double specVred2 = stepen(qi, j1 - i1) / (d2 - l + 1);

            if (specVred2 > specVred1)
            {
                if (res[qi] == -1 || specVred2 > res[qi])
                {
                    res[qi] = specVred2;
                    resL[qi] = l;
                    resD[qi] = d2;
                }
            }
            else {
                break;
            }
        }

        i = j + 1;
    }
}

int main()
{
    scanf("%d%d", &n, &q);
    for (int i = 0; i < n; i++)
    {
        scanf("%d", a + i);

        if (a[i] != 0 && a[i] != 1 && a[i] != 1e6)
        {
            flag1e6 = false;
        }
    }

    init();
    while (q--)
    {
        int qi;
        scanf("%d", &qi);

        if (res[qi] == -1)
        {
            resi(qi);
        }

        printf("%d %d\n", resL[qi], resD[qi]);
    }

    return 0;
}